function generateSlidiumChart(treeData){var svgParent=d3.select(treeData.bindTo);svgParent.selectAll("svg").remove();var svg=svgParent.append("svg");switch(treeData.chartType){case"org":var box=drawTree(d3.hierarchy(treeData.data[0]),"vertical",1,75,25,800,600,svg);svg.attr("viewBox",box.x-10+" "+(box.y-25)+" "+(box.w+20)+" "+(box.h+50));break;case"mind":var split_index=Math.round(treeData.data[0].children.length/2),data1={name:treeData.data[0].name,children:JSON.parse(JSON.stringify(treeData.data[0].children.slice(0,split_index)))},data2={name:treeData.data[0].name,children:JSON.parse(JSON.stringify(treeData.data[0].children.slice(split_index)))},right=d3.hierarchy(data1),box1=drawTree(d3.hierarchy(data2),"horizontal",-1,0,0,400,600,svg),box2=drawTree(right,"horizontal",1,0,0,400,600,svg),fullW=Math.max(box1.x+box1.w,box2.x+box2.w)-Math.min(box1.x,box2.x)+120,fullH=Math.max(box1.y+box1.h,box2.y+box2.h)-Math.min(box1.y,box2.y)-75;svg.attr("viewBox",Math.min(box1.x,box2.x)-80+" "+(Math.min(box1.y,box2.y)-25)+" "+fullW+" "+fullH);break;case"grid":box=drawGrid(d3.hierarchy(treeData.data).data,800,600,svg);svg.attr("viewBox","-10 -10 810 610");break;case"cycle":box=drawCycle(d3.hierarchy(treeData.data).data,800,600,svg);svg.attr("viewBox",box.x-10+" "+(box.y-25)+" "+(box.w+20)+" "+(box.h+50));break;case"sequence":box=drawSequence(d3.hierarchy(treeData.data).data,900,400,svg);svg.attr("viewBox",box.x-10+" "+(box.y+110)+" "+box.w+" "+(box.h-10));break;case"iphone":box=drawIPhone(d3.hierarchy(treeData.data).data,478,828,svg);svg.attr("viewBox","60 56 360 718");break;case"ipad":box=drawIPad(d3.hierarchy(treeData.data).data,784,601,svg);svg.attr("viewBox","0 0 784 601");break;case"browser":box=drawBrowser(d3.hierarchy(treeData.data).data,900,600,svg);svg.attr("viewBox","0 0 900 600");break;case"macbook":box=drawMacbook(d3.hierarchy(treeData.data).data,840,502,svg);svg.attr("viewBox","0 0 840 502");break;default:console.log("Unknown graph type")}}function drawMacbook(root,_w,_h,svg){svg.attr("class","svg-graph macbook");var macbook=svg.selectAll("rect").data(root).enter().append("g");macbook.append("path").attr("d","M750.615,2.257l-659.334,0c-17.94,0 -33.232,14.722 -33.232,32.955l0,433.668l725.799,0l0,-433.668c0,-18.235 -15.238,-32.955 -33.233,-32.955Z").attr("class","device"),macbook.append("foreignObject").attr("x",83).attr("y",32).attr("width",674).attr("height",417).attr("class","blockContainer macbook deviceblock").append("xhtml:div").attr("class","block").append("xhtml:div").attr("class","insideblock").html(function(d){return d.name}),macbook.append("path").attr("d","M771.949,497.658l-703.641,0c-36.579,0 -61.216,-9.771 -61.216,-13.927l0,-12.632c0,-1.249 1.595,-2.257 3.576,-2.257l818.921,0c1.985,0 3.581,1.008 3.581,2.257l0,13.129c-0.01,3.284 -19.088,13.43 -61.221,13.43Z").attr("class","device")}function drawIPhone(root,_w,_h,svg){svg.attr("class","svg-graph iphone");var iphone=svg.selectAll("rect").data(root).enter().append("g");iphone.append("path").attr("d","M366.6,75h-28.5c-6.1,0-8.3-0.8-8.7,6.9c-0.2,4-1.7,7-4,9.5c-2.4,2.5-5.6,4.7-9.3,5.8\tc-2.5,0.8-5.3,1.7-8,1.7h-5.4H181.9h-5.4c-2.7,0-5.5-1-8-1.8c-3.7-1.2-7-3.3-9.3-5.8c-2.4-2.6-3.8-5.5-4-9.5c-0.4-7.7-2.6-7-8.7-7\th-28.8C100.2,75,85,87.4,85,104.8v613.3c0,17.5,15.2,32.9,32.6,32.9h249c17.5,0,30.4-15.4,30.4-32.9V104.8\tC397,87.4,384.1,75,366.6,75z").attr("class","devicescreen"),iphone.append("foreignObject").attr("x",85).attr("y",75).attr("width",313).attr("height",677).attr("class","blockContainer iphone deviceblock").append("xhtml:div").attr("class","block").append("xhtml:div").attr("class","insideblock").html(function(d){return d.name}),iphone.append("path").attr("d","M416,219V106.6c0-28.8-22.4-50.6-51.2-50.6H116c-28.8,0-53,21.9-53,50.6V150h-3v27h3v25h-3v51h3v15h-3v51\th3v401.4c0,28.8,24.3,53.6,53,53.6h248.8c28.8,0,51.2-24.8,51.2-53.6V302h4v-83H416z M282.3,78.5c0,2.4-2,4.4-4.4,4.4\ts-4.4-2-4.4-4.4s2-4.4,4.4-4.4S282.3,76.1,282.3,78.5z M222.8,78h39c1.7,0,3,1,3,2.5s-1.3,2.5-3,2.5h-39c-1.7,0-3-1-3-2.5\tS221.1,78,222.8,78z M397,718.1c0,17.5-12.9,32.9-30.4,32.9h-249c-17.5,0-32.6-15.4-32.6-32.9V104.8C85,87.4,100.2,75,117.6,75\th28.8c6.1,0,8.3-0.9,8.7,6.8c0.2,4,1.7,7,4,9.6c2.4,2.5,5.6,4.8,9.3,5.9c2.5,0.8,5.3,1.7,8,1.7h5.4h120.7h5.4c2.7,0,5.5-1.1,8-1.9\tc3.7-1.2,7-3.2,9.3-5.7c2.4-2.5,3.8-5.4,4-9.4c0.4-7.7,2.6-7.1,8.7-7.1h28.5c17.5,0,30.4,12.4,30.4,29.8V718.1z").attr("class","device"),iphone.append("path").attr("d","M261.8,78h-39c-1.7,0-3,1-3,2.5s1.3,2.5,3,2.5h39c1.7,0,3-1,3-2.5S263.4,78,261.8,78z"),iphone.append("circle").attr("cx","277.9").attr("cy","78.5").attr("r","4.4")}function drawIPad(root,_w,_h,svg){svg.attr("class","svg-graph ipad");var ipad=svg.selectAll("rect").data(root).enter().append("g");ipad.append("path").attr("d","M2.034,36.383c0.552,0 1,0.448 1,1l0,31.161c0,0.552 -0.449,1 -1,1l-0.14,0c-0.552,0 -1,-0.448 -1,-1l0,-31.161c0,-0.552 0.448,-1 1,-1l0.14,0Zm123.013,-36.383c0.187,0 0.286,0.003 0.362,0.041c0.072,0.037 0.13,0.095 0.166,0.167c0.041,0.081 0.041,0.187 0.041,0.4l0,1.065c0,0.212 0,0.319 -0.041,0.4c-0.036,0.072 -0.094,0.13 -0.166,0.166c-0.081,0.042 -0.188,0.042 -0.401,0.042l-27.673,0c-0.213,0 -0.319,0 -0.401,-0.042c-0.071,-0.036 -0.129,-0.094 -0.166,-0.166c-0.041,-0.081 -0.041,-0.188 -0.041,-0.4l0,-1.065c0,-0.213 0,-0.319 0.041,-0.4c0.037,-0.072 0.095,-0.13 0.166,-0.167c0.082,-0.041 0.188,-0.041 0.401,-0.041l27.673,0l0.039,0Zm-32.122,1.673c0,0.212 0,0.319 -0.041,0.4c-0.036,0.072 -0.094,0.13 -0.166,0.166c-0.082,0.042 -0.188,0.042 -0.401,0.042l-26.913,0c-0.213,0 -0.319,0 -0.401,-0.042c-0.071,-0.036 -0.129,-0.094 -0.166,-0.166c-0.041,-0.081 -0.041,-0.188 -0.041,-0.4l0,-1.065c0,-0.213 0,-0.319 0.041,-0.4c0.037,-0.072 0.095,-0.13 0.166,-0.167c0.082,-0.041 0.188,-0.041 0.401,-0.041l26.913,0c0.213,0 0.319,0 0.401,0.041c0.072,0.037 0.13,0.095 0.166,0.167c0.041,0.081 0.041,0.187 0.041,0.4l0,1.065Z").attr("class","device"),ipad.append("foreignObject").attr("x",26).attr("y",25).attr("width",733).attr("height",550).attr("class","blockContainer ipad deviceblock").append("xhtml:div").attr("class","block").append("xhtml:div").attr("class","insideblock").html(function(d){return d.name}),ipad.append("path").attr("d","M37.047,1.521c-19.105,0 -34.592,15.487 -34.592,34.591l0,529.52c0,19.105 15.487,34.591 34.592,34.591l712.361,0c19.106,0 34.592,-15.486 34.592,-34.591l0,-529.52c0,-19.104 -15.486,-34.591 -34.592,-34.591l-712.361,0Zm0.38,26.228c-4.829,0 -8.743,3.915 -8.743,8.743l0,528.76c0,4.827 3.914,8.743 8.743,8.743l711.601,0c4.828,0 8.743,-3.916 8.743,-8.743l0,-528.76c0,-4.828 -3.915,-8.743 -8.743,-8.743l-711.601,0Z").attr("class","device")}function drawBrowser(root,_w,_h,svg){svg.attr("class","svg-graph browser");var browser=svg.selectAll("rect").data(root).enter().append("g");browser.append("path").attr("d","M895,18.089c0,-7.224 -5.865,-13.089 -13.089,-13.089l-863.822,0c-7.224,0 -13.089,5.865 -13.089,13.089l0,564.822c0,7.224 5.865,13.089 13.089,13.089l863.822,0c7.224,0 13.089,-5.865 13.089,-13.089l0,-564.822Z").attr("class","navigatorFrame"),browser.append("foreignObject").attr("x",7).attr("y",43).attr("width",886).attr("height",536).attr("class","blockContainer browser deviceblock").append("xhtml:div").attr("class","block").append("xhtml:div").attr("class","insideblock").html(function(d){return d.name}),browser.append("circle").attr("cx","21").attr("cy","22").attr("r","7").attr("class","trafficClose"),browser.append("circle").attr("cx","41").attr("cy","22").attr("r","7").attr("class","trafficMinimize"),browser.append("circle").attr("cx","61").attr("cy","22").attr("r","7").attr("class","trafficMaximize"),browser.append("path").attr("d","M874,18.5c0,-3.036 -2.464,-5.5 -5.5,-5.5l-773,0c-3.036,0 -5.5,2.464 -5.5,5.5l0,11c0,3.036 2.464,5.5 5.5,5.5l773,0c3.036,0 5.5,-2.464 5.5,-5.5l0,-11Z").attr("class","addressBar")}function drawCycle(root,_w,_h,svg){var nbItems=root.length,itemWidth=_w/nbItems*1.5,itemHeight=_h/nbItems,angle=360/nbItems,bar=svg.selectAll("rect").data(root).enter().append("g").attr("transform",function(d,i){return"translate("+(220*Math.sin(i*angle*Math.PI/180+Math.PI)+285)+" "+(220*Math.cos(i*angle*Math.PI/180+Math.PI)+220)+")"});bar.append("rect").attr("class","block").attr("rx",5).attr("width",itemWidth-10).attr("height",itemHeight-10),bar.append("foreignObject").attr("width",itemWidth-10).attr("height",itemHeight-10).attr("class","boxtext").append("xhtml:div").attr("class","insideblock").html(function(d){return d.name});var box=new Object;return box.x=0,box.y=0,box.w=_w,box.h=_h,box}function drawGrid(root,_w,_h,svg){var nbItems=root.length,columns=Math.floor(Math.sqrt(nbItems)),rows=Math.ceil(nbItems/columns),itemWidth=(_w-20*(columns-1))/columns,itemHeight=(_h-20*(rows-1))/rows;svg.attr("class","svg-graph blocks"),svg.selectAll("rect").data(root).enter().append("g").attr("transform",function(d,i){return"translate("+i%columns*itemWidth+","+Math.floor(i/columns)*itemHeight+")"}).append("foreignObject").attr("width",itemWidth).attr("height",itemHeight).attr("x",0).attr("y",0).attr("class","blockContainer blocks diagramblock").append("xhtml:div").attr("class","block").append("xhtml:div").attr("class","insideblock").html(function(d){return d.name});var box=new Object;return box.x=0,box.y=0,box.w=_w,box.h=_h,box}function drawSequence(root,_w,_h,svg){var nbItems=root.length,itemWidth=(_w-10)/nbItems;svg.attr("class","svg-graph sequence"),svg.append("path").attr("d","M439.931,470l0,-91.538l-433.931,0l0,-156.924l433.931,0l0,-91.538l352.569,170l-352.569,170Z").attr("class","bgshape");var bar=svg.selectAll("rect").data(root).enter().append("g").attr("transform",function(d,i){return"translate("+i%nbItems*itemWidth+",180)"});bar.append("rect").attr("class","block").attr("width",itemWidth-10).attr("height",240),bar.append("foreignObject").attr("width",itemWidth-10).attr("height",240).attr("class","blockContainer sequence diagramblock").append("xhtml:div").attr("class","block").append("xhtml:div").attr("class","insideblock").html(function(d){return d.name});var box=new Object;return box.x=0,box.y=0,box.w=_w,box.h=_h,box}function drawList(root){}function drawTree(root,orientation,revert,_x,_y,_w,_h,svg){var g=svg.append("g").attr("transform","translate("+_x+","+_y+")"),nodes=("vertical"==orientation?d3.tree().nodeSize([170,80]):d3.tree().nodeSize([170,170*revert]))(root),node=(g.selectAll(".link").data(nodes.descendants().slice(1)).enter().append("path").attr("class","link").attr("d",function(d){return"vertical"==orientation?"M"+d.x+","+d.y+"C"+d.x+","+(d.y+d.parent.y)/2+" "+d.parent.x+","+(d.y+d.parent.y)/2+" "+d.parent.x+","+d.parent.y:"M"+d.y+","+d.x+"C"+(d.parent.y+d.y)/2+","+d.x+" "+(d.parent.y+d.y)/2+","+d.parent.x+" "+d.parent.y+","+d.parent.x}),g.selectAll(".node").data(nodes.descendants()).enter().append("g").attr("class",function(d){return"node"+(d.children?" node--internal":" node--leaf")+" level"+d.depth}).attr("transform",function(d){return"horizontal"==orientation?"translate("+d.y+","+d.x+")":"translate("+d.x+","+d.y+")"}));node.append("rect").attr("width",150).attr("height",40).attr("rx",5).attr("transform","translate(-75,-20)").attr("class","box"),node.append("text").attr("dy",".35em").attr("y",0).style("text-anchor","middle").text(function(d){return d.data.name}).attr("transform",function(d){var bb=this.getBBox(),widthTransform=150/bb.width,heightTransform=40/bb.height,value=widthTransform<heightTransform?widthTransform:heightTransform;return"matrix("+(value=1<value?1:value)+", 0, 0, "+value+", 0,0)"});var _minX=1e5,_minY=1e5,_maxX=-1e5,_maxY=-1e5;nodes.each(function(d){_minX=Math.min(_minX,d.x),_minY=Math.min(_minY,d.y),_maxX=Math.max(_maxX,d.x+150),_maxY=Math.max(_maxY,d.y+40)});var box=new Object;return box.h="vertical"==orientation?(box.x=_minX,box.y=_minY,box.w=_maxX-_minX,_maxY-_minY):(box.x=_minY,box.y=_minX,box.w=_maxY-_minY,_maxX-_minX),box}